package gov.va.vinci.dart.dms.biz;

import gov.va.vinci.dart.service.DartObjectFactory;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

@Entity
@Table(name="label", schema="hib")
public class Label {

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	protected int id;

	@Version
	@Column(name="version")
	protected int version;  // for optimistic locking managed by Hibernate
	
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="documentid")
	Document document;
	
	@Column(name="value")
	private String value;

	public static Label findById(final int id) {
		return DartObjectFactory.getInstance().getLabelDAO().findById(id);
	}

	public static void deleteAllCurrentLabels(final int documentId) {
		DartObjectFactory.getInstance().getLabelDAO().deleteAllCurrentLabels(documentId);
	}

	Label(){}
	
	public static Label create(final Document document, final String value) {
		Label result = new Label();
		result.document = document;
		result.value = value;
		
		DartObjectFactory.getInstance().getLabelDAO().save(result);
		
		return result;
	}

	public String getValue() {
		return value;
	}
	
	public void delete() {
		DartObjectFactory.getInstance().getLabelDAO().delete(this);
	}
	
	
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	public Document getDocument() {
		return document;
	}
}
